# Intuition
<!-- Describe your first thoughts on how to solve this problem. -->
Visualise a little, it is just those nodes of the graph which aren't part of any cycle.

# Approach
<!-- Describe your approach to solving the problem. -->
For every node check if it is part of any cycle or not ( used a separate function for that ).

Used enum for storing the states of nodes, it was usefull in checking the presence of cycles.

Add all the nodes to answer list which aren't part of any cycles.

# Complexity
- Time complexity  : $$O( |V| + |E| )$$
<!-- Add your time complexity here, e.g. $$O(n)$$ -->

- Space complexity :  $$O( |V| + |E| )$$
<!-- Add your space complexity here, e.g. $$O(n)$$ -->

# Code
```
class Solution {
    enum States {        // These are special class that are used for storing cases // Ex: How are you : Good - Bad - Average ... it is just for example
    //Initial,
    Visiting, 
    Visited
}
    public List<Integer> eventualSafeNodes(int[][] graph) {
        List<Integer> li = new ArrayList<>();
        States[] state = new States[graph.length];

        for( int i = 0; i < graph.length; i++){     // for every node check if it is part of any cycle or not 
            if( !formsCycle( graph, i, state)){
                li.add(i);
            }
        }
        return li;
        
    }

    public boolean formsCycle( int[][] g, int n, States[] state){

        if( state[n] == States.Visiting){         // if we recursively reach the node which was in our path then we have found a cycle , so return true
            return true;
        }
        if( state[n] == States.Visited){          // it means we reached a terminal node , so return false
            return false;
        }

        state[n] = States.Visiting;       // initialise state[0] to be as a visiting state
        for( int e : g[n]){               // for every outgoing edge of present node , check if the forms a cycle or not
            if( formsCycle( g, e, state)){
                return true;
            }
        }
        state[n] = States.Visited;      // this code will execute if we reach terminal node

        return false;
    }
}
```